#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>
#include <fcntl.h>

#include "linuxfunc.h"

int _chdir(char* pathstr) 
{
	return (chdir (pathstr));
}

int _mkdir(char* pathstr) 
{
	return (mkdir (pathstr, 0));
}

char *_strupr(char *what) {
	int i = 0;
	while (what[i] != 0) {
		if (what[i] >= 'a' && what[i] <= 'z') {
			what[i] -= 'a' - 'A';
		}
		i++;
	}
	return (what);
};

char *_strlwr(char *what) {
	int i = 0;
	while (what[i] != 0) {
		if (what[i] >= 'A' && what[i] <= 'Z') {
			what[i] += 'a' - 'A';
		}
		i++;
	}
	return (what);
};

int stricmp(char *a,char *b){
	return strcasecmp(a,b);
};

int strnicmp(char *a,char *b,int n){
	return strncasecmp(a,b,n);
};

void _itoa(int i,char *a,int system){
	sprintf(a,"%i",i);
};

char *copy_string(char *src,int len) {
	char *temp=new char[len+1];
	strncpy(temp,src,len);
	temp[len]=0;
	return temp;
};

char *copy_string(char *src) {
	if (!src) return NULL;
	int len=strlen(src);
	return copy_string(src,len);
};

char *sum_strings(char *a,char *b) {
	int la=0;
	int lb=0;
	if (a) la=strlen(a);
	if (a) lb=strlen(b);
	char *temp=new char[la+lb+1];
	*temp=0;
	if (a) strcat(temp,a);
	if (b) strcat(temp,b);
	return temp;
};

char *sum_strings(char *a,char *b,char *c) {
	int la=0;
	int lb=0;
	int lc=0;
	if (a) la=strlen(a);
	if (b) lb=strlen(b);
	if (c) lc=strlen(c);
	char *temp=new char[la+lb+lc+1];
	*temp=0;
	if (a) strcat(temp,a);
	if (b) strcat(temp,b);
	if (c) strcat(temp,c);
	return temp;
};
